#version 330

uniform sampler2D color0Tex;
uniform mat4 invProj;
uniform float farClip;
uniform vec4 color;

in vec4 clipPos;
in vec3 viewSpaceLightPos;

out vec4 oColor;

vec2 toScreen(vec4 ndPos)
{
	return ndPos.xy*vec2(0.5, 0.5) + vec2(0.5, 0.5);
}

vec3 depthToPosition(float iDepth, vec4 iPosProj)
{
    vec3 vPosView = (invProj * iPosProj).xyz;
    vec3 vViewRay = vec3(vPosView.xy * (farClip / vPosView.z), farClip);
    vec3 vPosition = vViewRay * iDepth;
    return vPosition;
}

vec3 decodeNormal(vec2 enc)
{
    vec2 fenc = enc*4 - 2;
    float f = dot(fenc, fenc);
    float g = sqrt(1 - f/4);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1 - f/2;
    return n;
}

void main()
{
	vec2 screenUv = toScreen(clipPos/clipPos.w);
	
	vec4 normalDepth = textureLod(color0Tex, screenUv, 0);
	
	vec4 projSpace = vec4(clipPos.xy/clipPos.w, 0.0, 1.0);
	vec3 posVs = depthToPosition(normalDepth.z, projSpace);
	
	vec3 N = decodeNormal(normalDepth.xy);
	vec3 LightDir = (viewSpaceLightPos - posVs)*color.w;
	float l = length(LightDir);
	float AxNdotL = clamp(1.0 - l, 0.0, 1.0);
	AxNdotL *= clamp(dot(LightDir / l, N), 0.0, 1.0);
	if(AxNdotL == 0) discard;
	
	oColor = vec4(color.rgb*AxNdotL, 0.0);
	//oColor = vec4(color.rgb*0.1, 0.0);
}
